package Test::Web::TT;
use strict;
use warnings;
use encoding 'utf8';

use parent qw(IMPL::Test::Unit);
use IMPL::Test qw(test failed);
use IMPL::Web::TT::Document;

__PACKAGE__->PassThroughArgs;

test Creation => sub {
    my $document = new IMPL::Web::TT::Document();
    
    failed "Failed to create document" unless $document;
    
    $document->Dispose();
};

test SimpleTemplate => sub {
    my $document = new IMPL::Web::TT::Document();
    
    failed "Failed to create document" unless $document;
    
    $document->LoadFile('Resources/simple.tt','utf8');
    
    my $out = $document->Render;
    
    open my $hFile,'<:encoding(utf8)',"Resources/simple.txt" or die "Failed to open etalon file: $!";
    local $/;
    my $eta = <$hFile>;
    
    failed "Rendered data doesn't match the etalon data","Expected:\n$eta","Actual:\n$out" if $out ne $eta;
    
    $document->Dispose();
};


1;
