package IMPL::Object::List;
use strict;
use warnings;

use base qw(IMPL::Object::ArrayObject);
use IMPL::Exception;

sub as_list {
    return wantarray ? @{$_[0]} : $_[0];
}

sub CTOR {
    my ($this,$data) = @_;
    
    if ($data) {
        die new IMPL::InvalidArgumentException("The parameter should be a reference to an array") unless UNIVERSAL::isa($data,"ARRAY");
        @$this = @$data;
    }
}

sub Append {
    push @{$_[0]}, @_[1 .. $#_];
}

sub RemoveLast {
    return pop @{$_[0]};
}

sub AddFirst {
    return unshift @{$_[0]}, $_[1];
}

sub RemoveFirst {
    return shift @{$_[0]};
}

sub Count {
    return scalar @{$_[0]};
}

sub InsertAt {
    my ($this,$index,@val) = @_;
    
    splice @$this,($index||0),0,@val;
}

sub RemoveAt {
    my ($this,$index,$count) = @_;
    
    $count ||= 1;
    
    return splice @$this,$index,$count;
}

sub RemoveItem {
    my ($this,$item) = @_;
    
    @$this = grep $_ != $item, @$this;
    
    return $this;
}

sub RemoveItemStr {
    my ($this,$item) = @_;
    
    @$this = grep $_ ne $item, @$this;
    
    return $this;
}


1;
