package IMPL::Security::Principal;
use strict;
use warnings;

use parent qw(IMPL::Object IMPL::Object::Autofill);
use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

BEGIN {
    public property name => prop_get;
    public property description => prop_all;
}

my $nobody;

sub nobody {
    $nobody = $_[0]->new(name => 'nobody', description => '') unless $nobody;
    return $nobody;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Principal> Идентификатор пользователя

C<[Autofill]>

=head1 MEMBERS

=over

=item C<CTOR(%props)>

Создает новый объект.

=item C<[get] name>

Возвращает имя пользователя.

=item C<[get,set] description>

Возвращает описание пользователя.

=back

=cut
