package IMPL::Security::Role;

use parent qw(IMPL::Object);

use IMPL::Class::Property;

BEGIN {
	public property roleName => prop_get | owner_set;
	public property parentRoles => prop_get | owner_set | prop_list;
}

sub CTOR {
	my ($this,$name,$parentRoles) = @_;
	
	$this->roleName($name) if $name;
	$this->parentRoles($parentRoles) if $parentRoles;
}

sub Satisfy {
	my ($this,@roles) = @_;	
	
	return 1 unless $this->_FilterRoles( @roles );
	return 0;
}

sub _FilterRoles {
	my ($this,@roles) = @_;
	
	@roles = grep not (ref $_ ? $this == $_ : $this->roleName eq $_), @roles;
	
	@roles = $_->_FilterRoles(@roles) or return foreach $this->parentRoles ;
	
	return @roles;
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Role> Роль

=head1 DESCRIPTION

Может включать в себя базовые роли.
Имеется метод для проверки наличия необходимых ролей в текущей роли.

=head1 MEMBERS

=over

=item C<[get] roleName>

Имя роли, ее идентификатор

=item C<[get,list] parentRoles>

Список родительских ролей

=item C<Satisfy(@roles_list)>

Проверяет наличие ролей указанных ролей из списка @roles_list.
Допускается использование как самих объектов, так и имен ролей.
Возвращает 0 в случае неудачи (хотябы одна роль не была удовлетворена), 1 при наличии необходимых ролей.

=back

=cut
