package IMPL::ORM::Adapter::Generic;

1;

__END__

=pod

=head1 NAME

C<IMPL::ORM::Adapter::Generic> Адаптер для работы с данными объекта произвольного класса.

=head1 DESCRIPTION

Позволяет получать данные, изменения данных из объекта, а также записать данные в
объект и создать новый объект.

=head1 MEMBERS

=over

=item C<CTOR($object,$hashOptions)>

Создает новый адаптер к объекту C<$object>

=item C<[get]object>

Объект для которого создан данный адаптер, C<undef> если объект удален.

=item C<[get]isChanged>

Были ли обновления в объекте.

=item C<[get]isDeleted>

Является ли объект удаленным.

=item C<[get]isNew>

Является ли объект новым для БД.

=item C<[get]initialState>

Начальное состояние объекта, C<undef> если объект был создан.

=item C<[get]currentState>

Текущие состояние. C<undef> если объект удален.

=item C<[get,list]history>

История изменений. C<IMPL::Object::List>

=item C<SaveChanges>

Сохраняет изменения из объекта в текущее состояние, при этом изменения записываются в историю.

B<returns> информацию об изменениях в объекте. 

=item C<Revert($version)>

Возвращает объект в определенную версию.

=item C<Delete>

Удаляет объект, точнее помечает его для удаления до вызова C<Commit>.

=item C<Commit>

Сбрасывает историю изменений, и устанавливает соответсвующие свойства.

=back

=head1 Информация об изменениях объекта

=begin code

{
	version => 1, # object version
	op => STORAGE_UPDATE,
	data => {
		entity1 => {
			field1 => 'value 1'
		},
		entity2 => {
			field2 => 'value 2'
		}
	}
}

=end code

=head1 Информация об отображении объекта

=begin code

{
	prop_name => [ entity => 'field' ]
}

=end code

=cut
