package IMPL::SQL::Types;
use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(&Integer &Varchar &Float &Real &Text &Binary &DateTime);

require IMPL::SQL::Schema::Type;

sub Integer() {
    return IMPL::SQL::Schema::Type->new(name => 'INTEGER');
}

sub Varchar($) {
    return IMPL::SQL::Schema::Type->new(name => 'VARCHAR', maxLength => shift);
}

sub Float($) {
    return IMPL::SQL::Schema::Type->new(name => 'FLOAT', scale => shift);
}

sub Real() {
    return IMPL::SQL::Schema::Type->new(name => 'REAL');
}

sub Text() {
    return IMPL::SQL::Schema::Type->new(name => 'TEXT');
}

sub Binary() {
    return IMPL::SQL::Schema::Type->new(name => 'BINARY');
}

sub DateTime() {
    return IMPL::SQL::Schema::Type->new(name => 'DATETIME');
}

1;
