package IMPL::DOM::Schema::Node;
use strict;
use warnings;

use parent qw(IMPL::DOM::Node);
use IMPL::Class::Property;
use IMPL::DOM::Property qw(_dom);
use IMPL::Class::Property::Direct;

BEGIN {
    public _dom _direct property minOccur => prop_all;
    public _dom _direct property maxOccur => prop_all;
    public _dom _direct property type => prop_all;
    public _dom _direct property name => prop_all;
    public _dom _direct property display => prop_all;
    public _dom _direct property display_no => prop_all;
    public _dom _direct property display_blame => prop_all;
}

our %CTOR = (
    'IMPL::DOM::Node' => sub {
    	my %args = @_;
    	delete @args{qw(
    		minOccur
    		maxOccur
    		type
    		name
    		display
    		display_no
    		display_blame
    	)} ;
    	$args{nodeName} ||= 'Node';
    	%args
    }
);

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$minOccur} = defined $args{minOccur} ? $args{minOccur} : 1;
    $this->{$maxOccur} = defined $args{maxOccur} ? $args{maxOccur} : 1;
    $this->{$type} = $args{type};
    $this->{$name} = $args{name} or die new IMPL::InvalidArgumentException('Argument is required','name');
    $this->{$display} = $args{display} if $args{display};
    $this->{$display_no} = $args{display_no} if $args{display};
    $this->{$display_blame} = $args{display_blame} if $args{display};
}

sub Validate {
    my ($this,$node) = @_;
    
    if (my $schemaType = $this->{$type} ? $this->document->resolveType($this->{$type}) : undef ) {
        my @errors = $schemaType->Validate($node,{Source => $this});
        return @errors;
    } else {
        return ();
    }
}

sub inflateValue {
	$_[1];
}

sub inflator { undef }

sub qname {
    $_[0]->nodeName.'[name='.$_[0]->{$name}.']';
}

1;

__END__
=pod

=head1 SYNOPSIS

package SchemaEntity;
use parent qw(IMPL::DOM::Schema::Node);

sub Validate {
    my ($this,$node) = @_;
}

=head1 DESCRIPTION

Базовый класс для элементов схемы. Также позволяет объявлять узлы определенного типа.

=head1 MEMBERS

=head2 PROPERTIES

=over

=item C<[get,set] minOccur>

C<default: 1>.

Минимальное количество повторений узла.

=item C<[get,set] maxOccur>

C<default: 1>.

Максимальное количество повторений узла

=item C<[get,set] type>

C<default: undef>

Имя типа из схемы.

=item C<[get,set] name>

Имя узла.

=item C<[get,set] display>

Имя узла для отображения.

=item C<[get,set] display_no>

Имя узла для отображения (родительный падеж).

=item C<[get,set] display_blame>

Имя узла для отображения (винительный падеж).

=back

=cut
