#!/usr/bin/perl
use strict;
use Carp;
use Time::HiRes qw(gettimeofday tv_interval);
use Scalar::Util qw(blessed);
my $slot;
my $ref = bless \$slot, 'Wrapper';
sub is {
	my $slot = shift;
	bless \$slot, 'Wrapper';
}

sub instanceOf {
	carp "A typename can't be undefined" unless $_[1];
	blessed($_[0]) and $_[0]->isa($_[1])
}

my $bar = Bar->new();

my $t = [gettimeofday];

for(my $i =0; $i< 1000000; $i++) {
    is($bar)->instanceOf('Bar');
}

print "Is: ",tv_interval($t,[gettimeofday]),"\n";

$t = [gettimeofday];

for(my $i =0; $i< 1000000; $i++) {
    instanceOf($bar, 'Bar');
}

print "Is: ",tv_interval($t,[gettimeofday]),"\n";


package Wrapper;
use Scalar::Util qw(blessed);
sub instanceOf {
	blessed(${$_[0]}) and ${$_[0]}->isa($_[1]);
}

package Bar;
use IMPL::declare {
	base => ['IMPL::Object' => undef]
};

1;
