package IMPL::Web::View::TTControl;
use strict;

use IMPL::Const qw(:prop);
use IMPL::lang qw(:hash :base);
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgException => '-IMPL::InvalidArgumentException'
	},
	base => [
	   'IMPL::Object' => undef
	],
	props => [
		context => PROP_RO,
		template => PROP_RO
	]
};

our $AUTOLOAD_REGEX = qr/^[a-z]/;

sub CTOR {
    my ($this,$context,$template,$args) = @_;
    
    $this->context($context)
    	or die ArgException->new(context => 'A context is required');
    $this->template($template)
    	or die ArgException->new(template => 'A template is required');
    	
    if (ref $args eq 'HASH') {
    	while(my ($key, $value) = each %$args) {
    		next if grep $_ eq $key, qw(context template);
    		$this->$key($value);
    	}
    }
}

sub _PopulateMethods {
	my ($this,@methods) = @_;
	
	$this->_stash->update({
		map {
			my $name = $_;
			$name,
			sub {
				$this->$name(@_);
			}
		} @methods
	});
}

sub _stash {
	$_[0]->context->stash;
}

sub Render {
	my ($this,$args) = @_;
	return $this->context->include($this->template,$args);
}

our $AUTOLOAD;
sub AUTOLOAD {
	my ($prop) = ($AUTOLOAD =~ m/(\w+)$/);
	
	die Exception->new("Method not found: $AUTOLOAD") unless $prop=~/$AUTOLOAD_REGEX/ and $_[0];
	
	no strict 'refs';
	
	my $method = sub {
		my $that = shift;
		if (@_ == 0) {
			return $that->_stash->get($prop);
		} elsif (@_ == 1) {
			return $that->_stash->set($prop,shift);
		} else {
			return $that->_stash->get([$prop,[@_]]);
		}
	};
	
	*{$AUTOLOAD} = $method;
	
	goto &$method;
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::TTControl> расширяет функциональность шаблонов

=head1 SYNPOSIS

=begin code

package My::View::Menu;
use IMPL::declare {
	base => [
		'IMPL::Web::View::TTControl' => '@_'
	]
};

sub Render {
	my ($this,$args) = @_;
	
	$this->PrepareItems($args);
	
	return $this->next::method($args);
}

sub PrepareItems

=end code

=head1 DESCRIPTION


=cut