package IMPL::Config::ActivationContext;

use IMPL::Const qw(:prop);
use IMPL::Exception();
use IMPL::declare {
	require => {
		PropertyBag => 'IMPL::Config::ServicesBag'
	},
	base => {
		'IMPL::Object' => '@_'
	},
	props => {
		_services => PROP_RW,
		_cache => PROP_RW,
		_stack => PROP_RW
	}
};

sub GetService {
	my ($this,$serviceId) = @_;
	
	$this->_services->
}

sub EnterScope {
	my ($this, $name, $localize) = @_;
	
	my $info = { name => $name };
	
	if ($localize) {
		$info->{services} = $this->_services;
		
		$this->_services(PropertyBag->new($this->_services));
	}
	
	$this->_stack->Push($info);
}

sub LeaveScope {
	my ($this) = @_;
	
	my $info = $this->_stack->Pop()
		or die IMPL::InvalidOperationException();
	
	if ($info->{services})	
		$this->_services($info->{services});
}

1;
__END__

=pod

=head1 NAME

C<IMPL::Config::ActivationContext> - an activation context for the service

=head1 SYNOPSIS

For the internal use only

=head1 MEMBERS

=head2 METHODS

=head3 GetService($serviceId)

=cut