#!/usr/bin/perl
use strict;
use Carp;
use Time::HiRes qw(gettimeofday tv_interval);
use Scalar::Util qw(blessed refaddr);
use YAML::XS qw(Dump Load);
use Data::Dumper;
use URI;


use IMPL::require {
	Container => 'IMPL::Config::Container',
	Service => 'IMPL::Config::ServiceDescriptor',
	Reference => 'IMPL::Config::ReferenceDescriptor',
	Value => 'IMPL::Config::ValueDescriptor',
	YAMLConfig => 'IMPL::Config::YAMLConfig'
};


my $t = [gettimeofday];
my $config = YAMLConfig->new(load => 'sample.yaml');
print "Loaded: ",tv_interval($t,[gettimeofday]),"\n";

my $container = Container->new()->AutoPtr;
$config->ConfigureContainer($container);



print "Configured: ",tv_interval($t,[gettimeofday]),"\n";
#print Data::Dumper->Dump([$container]);
#$container->Dispose();

my $base = URI->new('some/path');
my $rel = URI->new('../other/path')->abs($base)->rel('/');
print $rel,"\n";

1;
