package IMPL::Security::Principal;
use strict;
use warnings;

use IMPL::Const qw(:prop);
use IMPL::require {
    AbstractPrincipal => 'IMPL::Security::AbstractPrincipal'
};
use IMPL::declare {
    base => [
        'IMPL::Object' => undef,
        'IMPL::Object::Autofill' => '@_',
        'IMPL::Security::AbstractPrincipal' => undef
    ],
    props => [
        @{AbstractPrincipal->abstractProps()},
        isNobody => PROP_RW
    ]
};

__PACKAGE__->abstractProps([]);

my $nobody;

sub nobody {
    $nobody = $_[0]->new(name => 'nobody', description => '', isNobody => 1) unless $nobody;
    return $nobody;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Principal> Идентификатор пользователя

C<[Autofill]>

=head1 MEMBERS

=over

=item C<CTOR(%props)>

Создает новый объект.

=item C<[get] name>

Возвращает имя пользователя.

=item C<[get,set] description>

Возвращает описание пользователя.

=back

=cut
