package IMPL::Debug;
use strict;
use warnings;

our $ENABLE = 0;
our %ENABLE;

my %subscriptions;
my @subscriptions;

sub stub { }

sub import {
    my ( $self, @args ) = @_;

    my $caller = caller;
    no strict 'refs';

    my $enabled = exists $ENABLE{$caller} ? $ENABLE{$caller} : $ENABLE;

    *{"${caller}::dbg_log"} = $enabled
      ? sub {
        $self->log( $caller, @_ );
      }
      : \&stub;

    *{"${caller}::dbg_error"} = $enabled
      ? sub {
        $self->log( $caller, @_ );
      }
      : \&stub;

    *{"${caller}::dbg_warn"} = $enabled
      ? sub {
        $self->log( $caller, @_ );
      }
      : \&stub;
}

sub log {
    my $self    = shift;
    my $channel = shift;
    $_->(@_) foreach @{ $subscriptions{$channel} || [] };
    $_->(@_) foreach @subscriptions;
}

sub subscribe {
    my ( $self, $channel, $callback ) = @_;

    if ( @_ == 2 ) {
        $callback = $channel;
        $channel  = undef;
    }

    die IMPL::InvalidArgumentException->new('callback')
      unless ref $callback eq 'CODE';

    if ($channel) {
        push @{ $subscriptions{$channel} }, $callback;
    }
    else {
        push @subscriptions, $callback;
    }
}

1;
