package IMPL::Web::DOM::FileNode;
use IMPL::base qw(IMPL::DOM::Node);

__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;
use File::Temp qw(tempfile);

BEGIN {
	public property parameterName => {
		get => sub {
			my ($this) = @_;
			$this->_parameterName() or
			$this->_parameterName(
				join '/', ( map {
					$_->nodeProperty('instanceId') ?
						$_->nodeName . '['.$_->nodeProperty('instanceId').']':
						$_->nodeName
				} $this->_selectParents, $this )
			);
		}
	};
	private property _parameterName => prop_all;
	public property fileName => {
		get => sub {
			my ($this) = @_;
			return $this->document->query->param($this->parameterName);
		}
	};
	public property fileHandle => {
		get => sub {
			my ($this) = @_;
			return $this->document->query->upload($this->parameterName);
		}
	};
}

sub invokeTempFile {
	my ($this,$sub,$target) = @_;
	
	die new IMPL::InvalidArgumentException("A reference to a function should be specified") unless $sub && ref $sub eq 'CODE';
	
	$target ||= $this;
	
	my $query = $this->document->nodeProperty('query') or die new IMPL::InvalidOperationException("Failed to get a CGI query from the document");
	my $hFile = $query->upload($this->parameterName) or $query->cgi_error ? die new IMPL::IOException("Failed to open the uploaded file",$query->cgi_error) : return;
			
	my ($hTemp,$tempFileName) = tempfile();
	binmode($hTemp);
	
	print $hTemp $_ while <$hFile>;
	
	$hTemp->flush();
	seek $hTemp, 0,0;
	{
		local $_ = $tempFileName;
		&$sub($this,$tempFileName,$hTemp);
	}
}

sub _selectParents {
	my ($node) = @_;
	
	my @result;
	
	unshift @result, $node while $node = $node->parentNode;
	
	return @result;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::DOM::FileNode> - ,         .

=head1 SINOPSYS

=begin code xml

<!-- input.schema.xml -->
<schema>
	<SimpleType type="file" nativeType="IMPL::Web::DOM::FileNode"/>
	<ComplexNode name="user">
		<Node type="file" name="avatar"/>
	</ComplexNode>
</schema>

=end code xml

=begin code

# handle.pl
use IMPL::DOM::Transform::PostToDOM ();
use IMPL::DOM::Schema;
use CGI;
use File::Copy qw(copy);

my $t = new IMPL::DOM::Transform::PostToDOM(
	undef,
	IMPL::DOM::Schema->LoadSchema('input.schema.xml'),
	'user'	
);

my $doc = $t->Transform(CGI->new());

if ($t->Errors->Count) {
	# handle errors	
}

$doc->selectSingleNode('avatar')->invokeTempFile(
	sub {
		my($node,$fname,$fhandle) = @_;
		
		# do smth with file
		copy($_,'avatar.jpg');
		
		# same thing
		# copy($fname,'avatar.jpg');
	}
);

=end code

=head1 DESCRIPTION

      C<CGI>   
     C<IMPL::DOM::Transform::PostToDOM>.

     C<IMPL::DOM::Node>   
    ,     .

=head1 MEMBERS

=head2 PROPERTIES

=over

=item C<[get] parameterName>

  C<CGI>    .

=item C<[get] fileName>

    

=item C<[get] fileHandle>

     

=back

=head2 METHODS

=over

=item C<invokeTempFile($callback,$target)>

 ,     ,  C<$callback>    .

=over

=item C<$callback>

         . C<callback($target,$fname,$fhandle)>

=over

=item C<$fname>

  

=item C<$fhandle>

   

=back
	
  C<$_>    .

=item C<$target>

        C<$callback>.

=back

=back

=cut