package Deployment::Batch::Backup;
use base qw(Deployment::Batch::Generic);
use Common;
use File::Copy;

BEGIN {
    DeclareProperty Action => ACCESS_READ;
}

sub CTOR {
    my ($this,$actionName,$actionArg) = @_;

    $this->{$Action} = { Name => $actionName, Arg => $actionArg };
}

sub Run {
    my ($this) = @_;

    my $tmpObj;
    
    # we are in the immediate mode
    if ($this->{$Action}{Name} eq 'File') {
        $this->Log("Backup file: $this->{$Action}{Arg}");
        if (-e $this->{$Action}{Arg}) {

            Deployment::Batch->Temp( File => \$tmpObj ) or die "Failed to create temp file" ;
        
            copy ($this->{$Action}{Arg}, $tmpObj->filename) or die "Failed to backup";
            $this->{$Action}{Result} = $tmpObj->filename;
        }
    } else {
        die "Don't know how to backup the $this->{$Action}{Name}";
    }
}

sub Rollback {
    my ($this) = @_;
    if ($this->{$Action}{Name} eq 'File') {
        $this->Log("Revert file: $this->{$Action}{Arg}");
        if ($this->{$Action}{Result}) {
            copy ($this->{$Action}{Result}, $this->{$Action}{Arg}) or die "Failed to backup";
        } else {
            unlink $this->{$Action}{Arg} if -f $this->{$Action}{Arg};
        }
    }
}

1;
