package Schema::Form::Item;
use strict;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty isMulti => ACCESS_READ;
    DeclareProperty Filters => ACCESS_READ;
    DeclareProperty Attributes => ACCESS_READ;
}

sub CTOR {
    my ($this,$name,$multi,$filters,$attributes) = @_;
    
    $this->{$Name} = $name or die new Exception("A name is required for the item");
    $this->{$isMulti} = defined $multi ? $multi : 0;
    $this->{$Filters} = $filters || [];
    $this->{$Attributes} = $attributes || {};
}

sub AddFilter {
    my ($this,$filter) = @_;
    
    push @{$this->{$Filters}}, $filter;
}

sub isMandatory {
    my ($this) = @_;

    return ( grep $_->Name eq 'mandatory', $this->Filters ) ? 1 : 0 ;
}

sub GetFirstFilter {
    my ($this,$filterName) = @_;
    
    my ($filter) = grep $_->Name eq $filterName, $this->Filters;
    return $filter;
}

1;
