package IMPL::ORM::Object;
use strict;
use warnings;

use base qw(IMPL::Object);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

require IMPL::ORM::Entity;

BEGIN {
    private _direct property _entities => prop_all;
}

my %schemaCache;

sub CTOR {
    my ($this) = @_;
    
    while ( my ($class,$schema) = $this->ormGetSchema ) {
        $this->{$_entities}{$class} = new IMPL::ORM::Entity($class,$schema);
    }
}

sub ormStore {
    my ($this,$class,$prop,$value) = @_;
    
    die IMPL::InvalidOperationException("Cannot find entity for the specified class",$class) unless $this->{$_entities}{$class};
    
    $this->{$_entities}{$class}->Store($prop,$value);
}

sub ormGet {
    my ($this,$class,$prop,$value) = @_;
    
    return $this->{$_entities}{$class} ? $this->{$_entities}{$class}->Get($prop,$value) : undef;
}

sub _PropertyImplementor {
    'IMPL::ORM::Property'
}

sub ormGetSchema {
    my ($self) = @_;
    
    my $class = ref $self || $self;
    
    return $schemaCache{$class} if $schemaCache{$class};
    
    my %schema;
    
    foreach my $ormProp (
        $self->get_meta(
            'IMPL::Class::PropertyInfo',
            sub {
                UNIVERSAL::isa($_->Implementor, 'IMPL::ORM::Property' )
            },
            1
        )
    ){
        push @{$schema{$ormProp->Class}},{
            name => $ormProp->Name,
            virtual => $ormProp->Virtual,
            type => $ormProp->Type
        };
    }
    
    return ($schemaCache{$class} = \%schema);
}

1;

__END__

=pod

=head1 DESCRIPTION

    ,
       .

=cut