use strict;
package IMPL::Web::TT::Form;

use base qw(IMPL::Web::TT::Control);

use IMPL::Class::Property;
use IMPL::DOM::Navigator::SchemaNavigator;
__PACKAGE__->PassThroughArgs;

BEGIN {
	public property base => prop_all;
	public property schema => prop_all;
	public property errors => prop_all;
	public property data => prop_all;
	public property state => prop_all;
	public property formResult => prop_all;
}

sub CTOR {
	my ($this) = @_;
	
	if (my $form = $this->formResult) {
		$this->base($form->{formName});
		$this->errors($form->{formErrors});
		$this->data($form->{formData});
		$this->schema($form->{formSchema});
		$this->state($form->{state});
	} else {
	
		$this->base($this->nodeName) unless $this->base;
		
		die new IMPL::InvalidArgumentException('A schema is required for a form',$this->nodeName)
			unless eval { $this->schema->isa( typeof IMPL::DOM::Schema ) };
		
		die new IMPL::InvalidOperationException('Can\'t find a form definition in a schema',$this->nodeName,$this->base)
			unless $this->schema->selectNodes(sub { $_->nodeName eq 'ComplexNode' and $_->name eq $this->base });
	}
			
	$this->errors([]) unless $this->errors;
}

sub makeControlArgs{
	my ($this,$path) = @_;
	
	my $navi = new IMPL::DOM::Navigator::SchemaNavigator($this->schema);
	my @path = ($this->base, split /\./,$path); 
	
	$navi->NavigateName($_) or die new IMPL::InvalidArgumentException(
		"Can't find a definition for an element",
		$_,
		$path,
		$this->element,
	) foreach @path;
	
	my $schema = $navi->Current;
	my $sourceSchema = $navi->SourceSchemaNode;
	my $queryParameter = join '/', @path;
	shift @path;
	my $node = $this->data ? $this->data->selectSingleNode(@path) : undef;
	
	my @errors;
	
	if ($node) {
		@errors = grep { ($_->Node || $_->Parent) == $node } @{$this->errors}; 
	} else {
		@errors = grep $_->Schema == $sourceSchema, @{$this->errors};
	}
	
	return {
		schema => $schema,
		sourceSchema => $sourceSchema,
		errors => \@errors,
		data => $node,
		nodeValue => $node && $node->nodeValue, # small hack set a non dom class property through
		queryParameter => $queryParameter
	};
}

sub formErrors {
	my ($this) = @_;
	
	if (my $node = $this->data ) {
		return [
			grep {
				( $_->Node || $_->Parent) == $node
			} @{$this->errors}
		];
	} else {
		return [];
	}
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Web::TT::Form> -   

=head1 DESCRIPTION

  ,     
 

=cut