package IMPL::DOM::Schema::SwitchNode;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema::AnyNode);
use IMPL::Class::Property;
require IMPL::DOM::Schema::ValidationError;
use IMPL::DOM::Property qw(_dom);

our %CTOR = (
    'IMPL::DOM::Schema::AnyNode' => sub {
        my %args = @_;
        
        $args{nodeName} ||= 'SwitchNode';
        
        %args;
    }
);

BEGIN {
    public _dom property messageNoMatch => prop_all;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->messageNoMatch($args{messageNoMatch} || 'A node %Node.nodeName% isn\'t expected in the %Parent.path%');
}

sub Validate {
    my ($this,$node,$ctx) = @_;
        
    if ( my ($schema) = $this->selectNodes(sub {$_[0]->name eq $node->nodeName} ) ) {
        return $schema->Validate($node);
    } else {
        return new IMPL::DOM::Schema::ValidationError(
            Node => $node,
            Source => $this,
            Message => $this->messageNoMatch
        );
    }
}

1;

__END__

=pod

=head1 DESCRIPTION

 ,      ,    .
    C<IMPL::DOM::Schema::AnyNode>.

=cut
