package IMPL::Web::QueryHandler::SecureCookie;
use strict;

use parent qw(IMPL::Web::QueryHandler);
use Digest::MD5 qw(md5_hex);

use IMPL::Class::Property;
use IMPL::Security::Auth qw(:Const);
use IMPL::Security;

BEGIN {
	public property salt => prop_all;
}

sub CTOR {
	my ($this) = @_;
	
	$this->salt('DeadBeef') unless $this->salt;
}

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
	return undef unless $nextHandler;
	
	local $IMPL::Security::authority = $this;
	
	my $method = $action->query->cookie('method') || 'simple';
	
	if ($method eq 'simple') {
		
		my $sid = $action->query->cookie('sid'); 
		my $cookie = $action->query->cookie('sdata');
		my $sign = $action->query->cookie('sign'); 
		
		if (
			$sid and
			$cookie and
			$sign and
			$sign eq md5_hex(
				$this->salt,
				$sid,
				$cookie,
				$this->salt
			)
		) {
			# TODO: add a DefferedProxy to deffer a request to a data source
			my $context = $action->application->security->sourceSession->find(
				{ id => $sid }
			) or return $nextHandler->();
			
			my ($result,$challenge) = $context->auth->ValidateSession($cookie);
			
			if ($result == AUTH_SUCCESS) {
				$context->authority($this);
				return $context->Impersonate($nextHandler);				
			} else {
				return $nextHandler->();
			}
		} else {
			return $nextHandler->();
		}
	} else {
		return $nextHandler->();
	}
}

sub WriteResponse {
	my ($this,$response,$sid,$cookie,$method) = @_;

	my $sign = md5_hex(
		$this->salt,
		$sid,
		$cookie,
		$this->salt
	);
	
	$response->setCookie(sid => $sid);
	$response->setCookie(sdata => $cookie);
	$response->setCookie(sign => $sign);
	$response->setCookie(method => $method) if $method;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::QueryHandler::SecureCookie>

=head1 DESCRIPTION

C<use parent qw(IMPL::Web::QueryHandler)>

        Cookie.

         
 - .

      .

=head1 MEMBERS

=over

=item C<[get,set] salt>

,    .

=back

=cut