package IMPL::Web::Security::Session;
use strict;
use parent qw(IMPL::Security::Context);

use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

BEGIN {
	public property id => prop_all | owner_set;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Security::Session> -  .

=head1 SINOPSYS

=begin code

# define a custom session for the application

package App::Session;
use parent qw(IMPL::Web::Security::Session);

use IMPL::Class::Property;

BEGIN {
	public property transactionId => prop_all;
}

=end code

=head1 DESCRIPTION

C<use parent qw(IMPL::Security::Context)>

   ,  .   
   .

=head1 MEMBERS

=over

=item C<[get] id>

 

=back

=cut