package Test::Web::Application::Instance;
package Test::Web::Application;
use strict;
use parent qw(IMPL::Test::Unit);

use IMPL::Test qw(test failed);
require IMPL::Web::Application;

__PACKAGE__->PassThroughArgs;

sub CTOR {
	# simulate CGI environment
	
	$ENV{PATH_TRANSLATED} = "Resources/simple.tt";
}

test SpawnApp => sub {
	my $instance = spawn Test::Web::Application::Instance('Resources/app.xml');
	
	return 1;
};

test ActivateOnDemand => sub {
	my $instance = spawn Test::Web::Application::Instance('Resources/app.xml');
	
	my $ds = $instance->dataSource;
	
	return 1;
};

test SaveXml => sub {
	my $instance = spawn Test::Web::Application::Instance('Resources/app.xml');
	
	$instance->xml or failed "xml property is invalid";	
};

test Run => sub {
	my $instance = spawn Test::Web::Application::Instance('Resources/app.xml');
	$instance->Run();
};

package Test::Web::Application::Instance;
use parent qw(IMPL::Web::Application);

__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;

BEGIN {
	public property name => prop_all;
	public property options => prop_all;
	public property dataSource => prop_all;
	public property securityMod => prop_all;
}


1;