package IMPL::DOM::Transform::QueryToDOM;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	base => [
	   'IMPL::DOM::Transform::ObjectToDOM' => '@_'
	],
	props => [
	   prefix => PROP_RO,
	   delimiter => PROP_RO
	]
};

sub CTOR {
	my ($this) = @_;
	
	$this->templates->{'CGI'} = \&TransformCGI;
	$this->templates->{'CGIWrapper'} = \&TransformCGI;
	
	$this->delimiter('[.]');
	$this->prefix('');
}

sub TransformCGI {
	my ($this,$query) = @_;

    my $data={};
    
    my $prefix = $this->prefix;
    my $delim = $this->delimiter;
    
    foreach my $param (grep index($_,$prefix) >= 0 , $query->param()) {
        length (my $value = $query->param($param)) or next;
        
        my @parts = split /$delim/,$param;
        
        my $node = $data;
        while ( my $part = shift @parts ) {
            if (my ($name,$index) = ($part =~ m/^(\w+)(?:\[(\d+)\])?$/) ) {
                if (@parts) {
                    if(defined $index) {
                        $node = ($node->{$name}[$index] ||= {});
                    } else {
                        $node = ($node->{$name} ||= {});
                    }
                } else {
                    if(defined $index) {
                        $node->{$name}[$index] = $value;
                    } else {
                        $node->{$name} = $value;
                    }
                }
            }
        }  
    }
    
    return $this->Transform($data);
}

1;