package IMPL::DOM::Schema::ComplexNode;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::Item);
use IMPL::Class::Property;

BEGIN {
    public property content => {
        get => \&_getContent,
        set => \&_setContent
    }
}

__PACKAGE__->PassThroughArgs;

sub _getContent {
    $_[0]->firstChild;
}

sub _setContent {
    $_[0]->firstChild($_[1]);
}

sub Validate {
    my ($this,$node) = @_;
    
    if (my $type = $this->nodeType) {
        my $schemaType = $this->Schema->ResolveType($type);
        return $schemaType->Validate($node);
    } else {
        my @errors;
        push @errors, $_->Validate foreach @{$this->childNodes};
        
        return @errors;
    }
}

1;

__END__

=pod

=head1 DESCRIPTION

  .    ,  
.

        ..
       , . C<content>

=head2 PROPERTIES

=over

=item C<content>

 ,    C<IMPL::DOM::Schema::NodeSet> 
C<IMPL::DOM::Schema::NodeList>,        .
       .

=back

=cut
