#!/usr/bin/perl
use strict;

use XML::Compile::Schema;
use XML::Compile::Util qw(pack_type pack_id);
use Data::Dumper;
use Time::HiRes qw(gettimeofday tv_interval);
    
my $schema = XML::Compile::Schema->new('Resources/resources.xsd');

$schema->printIndex();

my $type = pack_type 'http://implab.org/schemas/resources', 'resources';
my $reader = $schema->compile(
    READER => $type,
    xsi_type => {
    	pack_type('http://implab.org/schemas/resources','AbstractResult') => 'AUTO'
    }
);

my $t = [gettimeofday];

my $obj = $reader->('Resources/sample.xml');

print "Parsing small Xml file: ",tv_interval($t,[gettimeofday]),"\n";

print Dumper( $obj ); 
   
   
