package IMPL::Config::ServiceNotFoundException;
use strict;

use IMPL::declare {
    base => [
        'IMPL::AppException' => undef
    ],
    props => [
        serviceName     => 'ro',
    ]
};

use IMPL::Resources::Strings {
    message => "Service %serviceName% not found"
};

sub CTOR {
    my ( $this, %args ) = @_;

    $this->$_( $args{$_} ) foreach grep exists $args{$_}, qw(
      serviceName
    );
}

1;
