#!/usr/bin/perl
use strict;

use XML::Compile::Schema;
use XML::Compile::Util qw(pack_type);
use Data::Dumper;
use Time::HiRes qw(gettimeofday tv_interval);
    
my $schema = XML::Compile::Schema->new('Resources/person.xsd');

$schema->printIndex();

my $type = pack_type 'http://implab.org/person/', 'personInfo';
my $reader = $schema->compile(READER => $type);

my $t = [gettimeofday];

my $obj = $reader->('Resources/person_info.xml');

print "Parsing small Xml file: ",tv_interval($t,[gettimeofday]),"\n";

print Dumper( $obj ); 
   
   
