package IMPL::Web::Application::ControllerUnit;

use base qw(IMPL::Object);

use IMPL::Class::Property;

BEGIN {
	public property action => prop_get | owner_set;
	public property application => prop_get | owner_set;
	public property query => prop_get | owner_set;
}

sub CTOR {
	my ($this,$action) = @_;
	
	$this->action($action);
	$this->application($action->application);
	$this->query($action->query);
}

sub InvokeAction {
	my ($self,$method,$action) = @_;
	
	if ($self->can($method)) {
		my $unit = $self->new($action);
		$unit->$method();
	} else {
		die new IMPL::InvalidOperationException("Invalid method call",$self,$method);
	}
}