package IMPL::DOM::Schema::SimpleType;
use strict;
use warnings;

use IMPL::declare {
	require => {
		Label => 'IMPL::DOM::Schema::Label',
		ValidationError => 'IMPL::DOM::Schema::ValidationError'
	},
	base => [
		'IMPL::DOM::Schema::SimpleNode' => sub {
	        my %args = @_;
	        $args{nodeName} = 'SimpleType';
	        $args{minOccur} = 0;
	        $args{maxOccur} = 'unbounded';
	        $args{name} ||= 'SimpleType';
	        delete @args{qw(nativeType messageWrongType)};
	        %args
	    }
	],
	props => [
		nativeType => { get => 1, set => 1, direct => 1, dom => 1},
		messageWrongType => { get => 1, set => 1, direct => 1, dom => 1 }
	]
};

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$nativeType} = $args{nativeType} if $args{nativeType};
    $this->{$messageWrongType} = $args{messageWrongType} || "A simple node '%node.path%' is expected to be %schemaType.nativeType%"; 
}

sub Validate {
    my ($this, $node, $ctx) = @_;
    
    if ($this->{$nativeType}) {
        return ValidationError->new(
            node => $node,
            schemaNode => $ctx->{schemaNode} || $this,
            schemaType => $this,
            message => $this->_MakeLabel($this->messageWrongType)
        ) unless $node->isa($this->{$nativeType});
    }
    return $this->SUPER::Validate($node,$ctx);
}

sub qname {
    $_[0]->nodeName.'[type='.$_[0]->type.']';
}

sub _MakeLabel {
	my ($this,$label) = @_;
	
	if ($label =~ /^ID:(\w+)$/) {
		return Label->new($this->document->stringMap, $1);
	} else {
		return $label;
	}
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::Schema::SimpleType> - тип для простых узлов.

=head1 DESCRIPTION

Используется для описания простых узлов, которые можно отобразить в узлы
определенного типа при построении DOM документа.

=head1 MEMBERS

=over

=item C<nativeType>

Имя класса который будет представлять узел в DOM модели.

=item C<messageWrongType>

Формат сообщения которое будет выдано, если узел в дом модели не будет
соответствовать свойству C<nativeType>.

=back

=cut
