package IMPL::Config::ActivationException;
use strict;

use IMPL::declare {
	base => [
		'IMPL::AppException' => undef
	],
	props => [
		activationStack => 'ro',
		serviceName     => 'ro',
		innerException  => 'ro',
		reason          => 'ro'
	]
};

use IMPL::Resources::Strings {
	message => "Error activating %serviceName%: %reason%"
};

sub CTOR {
	my ( $this, %args ) = @_;

	$this->$_( $args{$_} ) foreach grep exists $args{$_}, qw(
	  activationStack
	  serviceName
	  innerException
	  reason
	);
}

1;
