package IMPL::Test::TAPListener;
use strict;
use warnings;

use parent qw(IMPL::Object IMPL::Object::Serializable);
use IMPL::Class::Property;
use IMPL::Test::Result;

BEGIN {
    private property _Output => prop_all;
    private property _testNo => prop_all;
}

sub CTOR {
    my ($this,$out) = @_;
    
    $this->_Output($out || *STDOUT);
    $this->_testNo(1);
}

sub RunPlan {
    my ($this,$plan) = @_;
    
    my $out = $this->_Output;
    
    print $out "1..",$plan->Count,"\n";
}

sub EndPlan {
    
}

sub RunUnit {
    my ($this,$unit) = @_;
    
    my $out = $this->_Output;
    
    print $out "#\n",join("\n",map "# $_", split /\n/, "Running unit: " . $unit->UnitName, ),"\n#\n";
}

sub EndUnit {
    
}

sub RunTest {
    
}

sub EndTest {
    my ($this,$test,$result) = @_;
    
    my $out = $this->_Output;
    my $n = $this->_testNo;
    
    $this->_testNo($n+1);
    
    print $out (
            $result->state == IMPL::Test::Result::SUCCESS ?
            "ok $n " . join("\n# ", split(/\n/, $result->name) )
                :
           (eval { $result->exception->isa('IMPL::Test::SkipException') } ? "ok $n #SKIP: " : "not ok $n ") . join("\n# ", split(/\n/, $result->name.": ".$result->exception || '') )
        ),"\n";
        
}

sub save {
    
}

1;
