package IMPL::DOM::Schema::SimpleType;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::SimpleNode);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property nativeType => prop_get;
    public _direct property messageWrongType => prop_get;
}

our %CTOR = (
    'IMPL::DOM::Schema::SimpleNode' => sub {
        my %args = @_;
        $args{nodeName} = 'SimpleType';
        $args{minOccur} = 0;
        $args{maxOccur} = 'unbounded';
        $args{name} ||= 'SimpleType';
        %args
    }
);

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$nativeType} = $args{nativeType};
    $this->{$messageWrongType} = $args{messageWrongType} || "A simple node '%Node.path%' is expected to be %Schema.nativeType%"; 
}

sub Validate {
	my ($this, $node) = @_;
	
	if ($this->{$nativeType}) {
		return new IMPL::DOM::Schema::ValidationError(
			Node => $node,
			Source => $this,
			Schema => $this,
			Message => $this->messageWrongType
		) unless $node->isa($this->{$nativeType});
	}
	return $this->SUPER::Validate($node);
}

sub qname {
	$_[0]->nodeName.'[type='.$_[0]->type.']';
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::Schema::SimpleType> -    .

=head1 DESCRIPTION

    ,     
    DOM .

=head1 MEMBERS

=over

=item C<nativeType>

       DOM .

=item C<messageWrongType>

    ,       
  C<nativeType>.

=back

=cut
