package IMPL::DOM::Schema::Property;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::SimpleNode);
require IMPL::DOM::Schema;
require IMPL::DOM::Node;
use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

BEGIN {
    public property RequiredMessage => prop_all;
}

our %CTOR = (
    'IMPL::DOM::Schema::SimpleNode' => sub {
        my %args = @_;
        
        $args{maxOccur} = 1;
        $args{minOccur} = delete $args{optional} ? 0 : 1;
        $args{nodeName} ||= 'Property';
        
        return %args;
    }
);

sub CTOR {
    my ($this,%args) = @_;
    
    $this->RequiredMessage($args{RequiredMessage} || 'A property %Schema.name% is required in the %Node.qname%');
}

sub Validate {
    my ($this,$node) = @_;
    
    my $prop = $this->name;
    
    # buld a pseudo node for the property value 
    my $nodeProp = new IMPL::DOM::Node(nodeName => '::property', nodeValue => eval { $node->$prop() } || $node->nodeProperty($prop));
        
    if ($nodeProp->nodeValue) {
    	# we have a value so validate it
    	return $this->SUPER::Validate($nodeProp);
    } elsif($this->minOccur) {
    	# we don't have a value but it's a mandatory property
        return new IMPL::DOM::Schema::ValidationError(
            Message => $this->RequiredMessage,
            Node => $node,
            Schema => $this
        );
    }
    
}

1;
