package IMPL::DOM::Schema::SimpleNode;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::Node);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
	public _direct property inflator => prop_get;
}

our %CTOR = (
    'IMPL::DOM::Schema::Node' => sub {my %args = @_; $args{nodeName} ||= 'SimpleNode'; %args}
);

sub CTOR {
	my ($this,%args) = @_;
	
	$this->{$inflator} = $args{inflator} if $args{iflator};
}

sub Validate {
    my ($this,$node) = @_;
    
    return map $_->Validate($node), @{$this->childNodes};
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::SimpleNode> -   .

=head1 DESCRIPTION

   .     
  .

  ,   DOM    
      C<IMPL::DOM::Node>.

        DOM .

=cut
