package IMPL::Config::Container;
use strict;
use warnings;

use base qw(IMPL::Config);
use IMPL::Class::Property;

BEGIN {
    public property Chidren => prop_all;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->Chidren(\%args);
}

sub save {
    my ($this,$ctx) = @_;
    
    while (my ($key,$value) = each %{$this->Chidren}) {
        $ctx->AddVar($key,$value);
    }
}

our $AUTOLOAD;
sub AUTOLOAD {
    my $this = shift;
    
    (my $prop = $AUTOLOAD) =~ s/.*?(\w+)$/$1/;
    
    my $child = $this->Chidren->{$prop};
    if (ref $child and $child->isa('IMPL::Config::Class')) {
        return $child->instance(@_);
    } else {
        return $child;
    }
}

1;
