use strict;
package Engine::Security;
use Security::Auth;
use Security;
use Engine::Security::Auth;

our @AuthMethods;
my $AuthResult;
my $AuthMod;
my $AuthMethod;

# use last auth method as default
$AuthMethod = Engine::Security::Auth->new(%{$AuthMethods[$#AuthMethods]}) if @AuthMethods;

sub AuthenticateContext {
    Security->CurrentSession(undef); #prevent previous session from closing
    foreach my $method (@AuthMethods) {
        my $AuthObj = Engine::Security::Auth->new(%$method);
        $AuthResult = $AuthObj->DoAuth();
        #    ,    
        $AuthObj->SetAuthResult($AuthResult) if $AuthResult->State == Security::AUTH_FAILED or $AuthResult->State == Security::AUTH_SUCCESS;
        $AuthMethod = $AuthObj and last if $AuthResult->State != Security::AUTH_FAILED and $AuthResult->State != Security::AUTH_NOAUTH;
    }
    $AuthMod = $AuthMethod->AuthMod if $AuthMethod;
}

sub SetAuthResult {
    shift;
    $AuthMethod->SetAuthResult(@_) if $AuthMethod;
}

sub AuthMod {
    return $AuthMethod ? $AuthMethod->AuthMod : undef;
}

1;