package IMPL::Web::Application::ViewResult;
use strict;

use IMPL::lang qw(:declare);
use IMPL::declare {
	base => [
	   'IMPL::Web::Application::ActionResult' => '@_'
	]
};

BEGIN {
	public property model => PROP_ALL;
}

sub CTOR {
	my $this = shift;
	$this->status('200 OK') unless $this->status;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::ViewResult> - Результат для которого требуется создать
представление.

=head1 SYNOPSIS

=begin code

use IMPL::require {
	View => 'IMPL::Web::Application::ViewResult'
};

sub ViewItem {
	my ($this,$id) = @_;
	
	my $view = View->new(model => $this->items->find($id));
	$view->cookies->{'Some cookie'} = 'some value';
	return $view;
}

=end code

=head1 DESCRIPTION

Наследует C<IMPL::Web::Application::ActionResult>.

Позволяет сформировать C<HTTP> ответ с указанием расширенных свойств и данных.
Как правило данный класс не требуется использовать на прямую, он создается
системой по-умолчанию для представления результатов методов предметной области.

Следует избегать использование данного класса непосредственно при реализации
предметной области, поскольку она должна быть отделена от контроллеров и
представления.

=head1 MEMBERS

=head2 C<[get,set]model>

Объект для которого необходимо построить представление.

=cut