package IMPL::Web::Application;
use strict;
use warnings;

use base qw(IMPL::Config IMPL::Object::Singleton);

require IMPL::Web::Application::Action;
require IMPL::Web::Application::Response;

use IMPL::Class::Property;
use CGI;

__PACKAGE__->PassThroughArgs;

BEGIN {
    public property handlerError => prop_all;
    public property factoryAction => prop_all;
    public property handlersQuery => prop_all | prop_list;
    public property configuration => prop_all;
}

# custom factory
sub new {
    my ($self,$file) = @_;
    
    return $self->LoadXMLFile($file);
}

sub CTOR {
	my ($this) = @_;
	
	$this->factoryAction('IMPL::Web::Application::Action') unless $this->factoryAction;
}

sub Run {
    my ($this) = @_;
    
    while (my $query = $this->FetchRequest()) {
        my $response = new IMPL::Web::Application::Response(query => $query);
        
        my $action = $this->factoryAction->new(
        	query => $query,
        	response => $response,
        	application => $this, 
        ); 
        
        $action->ChainHandler($_) foreach $this->handlersQuery;
        
        $action->Invoke();
    }
}

{
	my $hasFetched = 0;

	sub FetchRequest {
		return undef if $hasFetched;
		$hasFetched = 1;
		return CGI->new();
	}
}

1;

__END__

=pod

=head1 SYNOPSIS

require MyApp;
MyApp->spawn('app.config')->Run();

=head1 DESCRIPTION

      ,   ,
     CGI    .

      

1.  cgi 
2.      
3.    
4.  
5.      




=cut
