package Form::ValueItem;
use strict;
use base qw(Form::Item);
use Common;
use Form::Filter;

BEGIN {
    DeclareProperty Value => ACCESS_ALL;
    DeclareProperty Type => ACCESS_READ;
    DeclareProperty Schema => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->SUPER::CTOR(@args{qw(Id Form Parent Attributes)});
    $this->{$Type} = $args{'Type'};
    $this->{$Schema} = $args{'Schema'} or die new Exception('A field schema is required');
}

sub isEmpty {
    my ($this) = @_;
    
    return length $this->{$Value} ? 0 : 1;
}

sub Validate {
    my ($this,$rhDisableFilters) = @_;
    
    $rhDisableFilters ||= {};

    my @errors;

    foreach my $filter (grep {$_->SUPPORTED_CONTEXT & (Form::Filter::CTX_SINGLE) and not exists $rhDisableFilters->{$_}} map {$_->Instance} $this->{$Schema}->Filters) {
        my $result = $filter->Invoke($this,Form::Filter::CTX_SINGLE | Form::Filter::CTX_EXISTENT,$this->{$Schema},$this->Parent);
        if ($result->State == Form::FilterResult::STATE_SUCCESS_STOP) {
            return ();
        } elsif ($result->State == Form::FilterResult::STATE_ERROR) {
            push @errors,$result;
        }
    }
    
    return @errors;
}


1;
