use strict;
package IMPL::SQL::Schema::Constraint;
use base qw(IMPL::Object IMPL::Object::Disposable);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property Name => prop_get;
    public _direct property Table => prop_get;
    public _direct property Columns => prop_get;
}

sub CTOR {
    my ($this,%args) = @_;
    die new IMPL::InvalidArgumentException("The table argument must be an instance of a table object") if not UNIVERSAL::isa($args{'Table'},'IMPL::SQL::Schema::Table');
    $this->{$Name} = $args{'Name'};
    $this->{$Table} = $args{'Table'};
    $this->{$Columns} = [map { ResolveColumn($this->Table,$_) } @{$args{'Columns'}}];
}

sub ResolveColumn {
    my ($Table,$Column) = @_;
    
    my $cn = UNIVERSAL::isa($Column,'IMPL::SQL::Schema::Column') ? $Column->Name : $Column;
    
    my $resolved = $Table->Column($cn);
    die new IMPL::InvalidOperationException("The column is not found in the table", $cn, $Table->Name) if not $resolved;
    return $resolved;
}

sub HasColumn {
    my ($this,@Columns) = @_;
    
    my %Columns = map { $_, 1} @Columns;
    
    return scalar(grep { $Columns{$_->Name} } @{$this->Columns}) == scalar(@Columns);
}

sub UniqName {
    my ($this) = @_;
    return $this->{$Table}->Name.'_'.$this->{$Name};
}

sub Dispose {
    my ($this) = @_;
    
    delete @$this{$Table,$Columns};
    $this->SUPER::Dispose;
}
1;
