use strict;
package Schema::DB;
use Common;
use Schema::DB::Table;

our @ISA = qw(Object);

BEGIN {
    DeclareProperty Version => ACCESS_READ;
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty Tables => ACCESS_READ;
}

sub AddTable {
    my ($this,$table) = @_;
    
    if (UNIVERSAL::isa($table,'Schema::DB::Table')) {
        $table->Schema == $this or die new Exception('The specified table must belong to the database');
        not exists $this->{$Tables}->{$table->Name} or die new Exception('a table with the same name already exists in the database');
    } elsif (UNIVERSAL::isa($table,'HASH')) {
        not exists $this->{$Tables}->{$table->{'Name'}} or die new Exception('a table with the same name already exists in the database');
        $table->{'Schema'} = $this;
        $table = new Schema::DB::Table(%{$table});
    } else {
        die new Exception('Either a table object or a hash with table parameters is required');
    }
    
    $this->{$Tables}{$table->Name} = $table;
}

sub RemoveTable {
    my ($this,$table) = @_;
    
    my $tn = UNIVERSAL::isa($table,'Schema::DB::Table') ? $table->Name : $table;
    $table = delete $this->{$Tables}{$tn} or die new Exception('The table doesn\'t exists',$tn);
    
    # drop foreign keys
    map { $_->Table->RemoveConstraint($_) } values %{$table->PrimaryKey->ConnectedFK} if $table->PrimaryKey;
    
    # drop table contents
    $table->Dispose();

    return 1;
}

sub Dispose {
    my ($this) = @_;
    
    $_->Dispose foreach values %{$this->{$Tables}};
    
    delete $this->{$Tables};
    
    $this->SUPER::Dispose;
}


1;
