use strict;
package IMPL::SQL::Schema::Column;

use IMPL::lang qw( :DEFAULT :compare :hash );
use IMPL::Exception();
use IMPL::Const qw(:prop);
use IMPL::declare {
    require => {
        SchemaType => '-IMPL::SQL::Schema::Type'
    },
    base => [
        'IMPL::Object' => undef,
        'IMPL::Object::Autofill' => '@_'
    ],
    props => [
        name => PROP_RO | PROP_DIRECT,
        type => PROP_RO | PROP_DIRECT,
        isNullable => PROP_RO | PROP_DIRECT,
        defaultValue => PROP_RO | PROP_DIRECT,
        tag => PROP_RO | PROP_DIRECT
    ]
};

sub CTOR {
    my $this = shift;
    
    $this->{$name} or
        die new IMPL::InvalidArgumentException('A column name is required');
    
    $this->{$isNullable} ||= 0; # if not exists $this->{$isNullable};
    
    is( $this->{$type}, SchemaType) or
        die new IMPL::InvalidArgumentException('a type is required for the column',$this->{$name});
}

sub SameValue {
    my ($this,$other) = @_;
    
    return (
        $this->{$name} eq $other->{$name}
        and $this->{$isNullable} == $other->{$isNullable}
        and equals_s($this->{$defaultValue}, $other->{$defaultValue})
        and $this->{$type}->SameValue($other->{$type})
    );
}

sub SetType {
    my ($this,$newType) = @_;
    
    $this->{$type} = $newType;
}

sub SetDefaultValue {
    my ($this,$value) = @_;
    
    $this->{$defaultValue} = $value;
}

sub SetNullable {
    my ($this, $value) = @_;
    
    $this->{$isNullable} = $value;
}

sub SetOptions {
    my ($this,$diff) = @_;
    
    return unless ref $diff eq 'HASH';
    
    $this->tag({}) unless $this->tag;
    
    hashApply($this->tag,$diff);
}

1; 
