package IMPL::Config::ReferenceDescriptor;
use strict;

use IMPL::Exception();
use IMPL::declare {
	base => [
		'IMPL::Object'             => undef,
		'IMPL::Config::Descriptor' => undef
	],
	props => [
		reference => 'ro',
		services  => 'ro',
		lazy      => 'ro',
		optional  => 'ro',
		default   => 'ro',
		_name     => 'rw'
	]
};

sub CTOR {
	my ( $this, $ref, %opts ) = @_;

	$this->reference($ref)
	  or die IMPL::InvalidArgumentException->new('ref');

	$this->lazy( $opts{lazy} )         if $opts{lazy};
	$this->optional( $opts{optional} ) if $opts{optional};
	$this->default( $opts{default} )
	  if $opts{optional} and exists $opts{default};

	$this->_name( 'ref ' . $ref );
}

sub Activate {
	my ( $this, $context ) = @_;

	$this->EnterScope( $this->_name, $this->services );

	my $ref = $this->reference;
	my %opts;
	$opts{default} = $this->default
	  if $this->optional;

	if ( $this->lazy ) {
		my $clone = $context->Clone();
		return sub {
			$clone->Resolve( $ref, %opts );
		};
	}
	else {
		return $context->Resolve( $ref, %opts );
	}

	$this->LeaveScope();
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Config::ReferenceDescriptor> - A descriptor which is points to the other service

=head1 MEMBERS

=head2 PROPS

=head3 reference

=head3 lazy

=head3 optional

=head3 default

=head2 METHODS

=head3 CTOR($ref, %opts)

=head3 Activate($context)

Returns a result of the activation of the service specified by the C<reference> property.

If the reference is lazy the method returns a closure.The C<$context> will be cloned and the clone will be used to create the closure. 
=cut
