package IMPL::Web::Application::CustomResource;
use strict;

use IMPL::Const qw(:prop);

use IMPL::declare {
    require => {
        Factory => 'IMPL::Object::Factory',
        CustomResourceContract => 'IMPL::Web::Application::CustomResourceContract'        
    },
    base => [
        'IMPL::Web::Application::Resource' => '@_'
    ],
    props => [
        accessCheck => PROP_RW
    ]
};

__PACKAGE__->static_accessor(contractFactory => CustomResourceContract );
__PACKAGE__->static_accessor_own(_contractInstance => undef);

sub CTOR {
	my ($this,%args) = @_;
	
	$this->accessCheck($args{accessCheck})
	   if $args{accessCheck};
}

sub contractInstance {
    my ($self) = @_;
    
    $self = ref $self || $self;
    $self->_contractInstance ? $self->_contractInstance : $self->InitContract();
}

sub InitContract {
    my ($self) = @_;
    $self->_contractInstance(
        $self->contractFactory->new(
            resourceFactory => $self,
            resources => [ $self->GetChildResources() ]
        )
    ); 
}

sub CreateContract {
    my ($self, %args) = @_;
    
    $self->contractFactory->new(
        resourceFactory => Factory->new(
            $self,
            \%args
        ),
        resources => [ $self->GetChildResources() ]
    )
}

sub CreateResource {
    my ($self,%args) = @_;
    
    $self->CreateContract()->CreateResource(%args);
}

sub AccessCheck {
	my ($this,$verb) = @_;
	
	my $handler = $this->accessCheck; 
	
	if(ref($handler) eq 'CODE') {
		&$handler($this,$verb);
	}
}

sub GetChildResources {
    
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::CustomResource> - базовый класс для ресурсов,
реальзуемых в коде.

=head1 SYNOPSIS

=begin code

package MyApp::Web::Resources::ProfileResource;
use IMPL::declare {
    base => [
        'IMPL::Web::Application::CustomResource' => '@_'
    ]
}

sub HttpGet {
    my ($this) = @_;
    return $this->model;
}

sub HttpPut {
    my ($this,$action) = @_;
    
    my $form = MyApp::Web::Schema::UpdateUser->new();
    
    $this->model->update( $form->Bind($action) );
}

our %COMPONENTS = (
	item => {
		verbs => {
			get => sub {
				shift->model;
			}
		},
		resources => [
			edit => 
		]
	}
);

=end code

=head1 MEMBERS

=head2 C<[static]contractFactory>

Фабрика, используемая для получения контракта ресурса. По умолчанию
C<IMPL::Web::Application::CustomResourceContract>.

=head2 C<[static]contractInstance>

Экземпляр контракта для ресурса. Создается при первом обращении при помощи
метода C<InitContract()>.

=head2 C<[static]InitContract()>

Создает новый экземпляр контракта, используя фабрику из свойства C<contractFactory>.

=head2 C<[static]CreateContract(%args)>

Создает новый контракт, который при создании ресурсов будет передавать им в
конструкторе параметры C<%args>. Реализуется при помощи C<IMPL::Object::Factory>
которой задается параметр ссылка на C<%args>, т.о. при создании ресурса, ему в
конструкторе будет передан список из ключей и значений хеша C<%args>, а затем
остальные аргументы.

=head2 C<[static]CreateResource(%args)>

Создает контракт по-умолчанию и вызывает у него метод C<CreateResource(%args)>.

=head2 C<[static]GetChildResources()>

Статический метод, который должны переопределять новые классы ресурсов, у
которых есть дочерние ресурсы.

=begin code

package MyApp::Web::MyResource

sub GetChildResources {
    my $self = shift;
    return
        $self->SUPER::GetChildResources(),
        {
            name => 'info',
            contract => $contractInfo
        };
}

=end code

Метод возвращает список из хешей, которые будут переданы в качестве параметра
C<resources> контракту данного ресурса.

=cut