package IMPL::DOM::Schema::Node;
use strict;
use warnings;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Label => 'IMPL::DOM::Schema::Label'
	},
	base => [
		'IMPL::DOM::Node' => sub {
	        my %args = @_;
	        delete @args{qw(
	            minOccur
	            maxOccur
	            type
	            name
	        )} ;
	        $args{nodeName} ||= 'Node';
	        %args
	    }
	],
	props => [
		minOccur => { get => 1, set => 1, direct => 1, dom => 1},
		maxOccur => { get => 1, set => 1, direct => 1, dom => 1},
		type => { get => 1, set => 1, direct => 1, dom => 1},
		name => { get => 1, set => 1, direct => 1, dom => 1},
		label => { get => '_getLabel', direct => 1 }
	]
};

sub _getLabel {
	my ($this) = @_;
	
	$this->{$label} ||= Label->new($this->document->stringMap, $this->name ); 
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$minOccur} = defined $args{minOccur} ? $args{minOccur} : 1;
    $this->{$maxOccur} = defined $args{maxOccur} ? $args{maxOccur} : 1;
    $this->{$type} = $args{type};
    $this->{$name} = $args{name} or die new IMPL::InvalidArgumentException('Argument is required','name');
}

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    $ctx->{schemaNode} = $this; # запоминаем источник ссылки
    
    if (my $schemaType = $this->{$type} ? $this->document->ResolveType($this->{$type}) : undef ) {
        my @errors = $schemaType->Validate($node,$ctx);
        return @errors;
    } else {
        return ();
    }
}

sub isOptional {
    my ($this) = @_;
    
    return $this->{$minOccur} ? 0 : 1;
}

sub isMultiple {
    my ($this) = @_;
    
    return ($this->{$maxOccur} eq 'unbounded' || $this->{$maxOccur} > 1 ) ? 1 : 0; 
}

sub qname {
    $_[0]->nodeName.'[name='.$_[0]->{$name}.']';
}

1;

__END__
=pod

=head1 SYNOPSIS

package SchemaEntity;
use parent qw(IMPL::DOM::Schema::Node);

sub Validate {
    my ($this,$node) = @_;
}

=head1 DESCRIPTION

Базовый класс для элементов схемы. Также позволяет объявлять узлы определенного типа.

=head1 MEMBERS

=head2 PROPERTIES

=over

=item C<[get,set] minOccur>

C<default: 1>.

Минимальное количество повторений узла.

=item C<[get,set] maxOccur>

C<default: 1>.

Максимальное количество повторений узла

=item C<[get,set] type>

C<default: undef>

Имя типа из схемы.

=item C<[get,set] name>

Имя узла.

=back

=cut
