package IMPL::Config::ServicesBag;

use IMPL::Const qw(:prop);
use IMPL::declare {
	base => {
		'IMPL::Object' => undef
	},
	props => {
		_prototype => PROP_RW,
		_nameMap => PROP_RW,
		_typeMap => PROP_RW,
		_props => PROP_RW,
	}
};

sub GetDescriptorByName {
	my ($this, $name) = @_;
	
	my $d = $this->_namedMap->{$name};
	if ($d && $d->{valid})
		return $d;
	
	my $parent = $this->_prototype;
	if ($parent && $d = $parent->GetDescriptorByName($name))
		return $this->_namedMap->{$name} = $d;
		
	return undef;
}

sub GetDescriptorByType {
	my ($this, $type) = @_;
	
	my $d = $this->_typeMap->{$name};
	if ($d && $d->{valid})
		return $d;
	
	my $parent = $this->_prototype;
	if ($parent && $d = $parent->GetDescriptorByType($name))
		return $this->_typeMap->{$name} = $d;
		
	return undef;	
}

sub Register

1;

__END__

=pod

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

Коллекция сервисов построена на прототиптровании экземпляров, т.е. при создании
новой коллекции может указваться базовая коллекция в которой будет происходить
поиск сервисов в случае их отсутсвия в основной. Для оптимизации данного процесса
сервисы кешируются, чтобы избежать можестрвенных операций поиска по иерархии
коллекций, для этого каждый сервис описывается дескриптором:

=over

=item * name название под которым сервис зарегистрирован

=item * type тип сервиса

=item * service фабрика сервиса

=item * valid признак того, что дескриптор действителен

=back

Если запрашиваемый десриптор не найден это является ошибкой, поэтому негативные
ответы не кешируются

=cut