package IMPL::DOM::Schema::Node;
use strict;
use warnings;

use base qw(IMPL::DOM::Node);
use IMPL::Class::Property;
use IMPL::DOM::Property qw(_dom);
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property minOccur => prop_all;
    public _direct property maxOccur => prop_all;
    public _direct property type => prop_all;
    public _direct property name => prop_all;
    public _direct property display => prop_all;
    public _direct property display_no => prop_all;
    public _direct property display_blame => prop_all;
}

our %CTOR = (
    'IMPL::DOM::Node' => sub {my %args = @_; $args{nodeName} ||= 'Node'; %args}
);

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$minOccur} = defined $args{minOccur} ? $args{minOccur} : 1;
    $this->{$maxOccur} = defined $args{maxOccur} ? $args{maxOccur} : 1;
    $this->{$type} = $args{type};
    $this->{$name} = $args{name} or die new IMPL::InvalidArgumentException('Argument is required','name');
    $this->{$display} = $args{display};
    $this->{$display_no} = $args{display_no};
    $this->{$display_blame} = $args{display_blame};
}

sub Validate {
    my ($this,$node) = @_;
    
    if (my $schemaType = $this->{$type} ? $this->document->resolveType($this->{$type}) : undef ) {
        return $schemaType->Validate($node);
    } else {
        return ();
    }
}

sub qname {
    $_[0]->nodeName.'[name='.$_[0]->{$name}.']';
}

1;

__END__
=pod

=head1 SYNOPSIS

package Restriction;
use base qw(IMPL::DOM::Schema::Item);

sub Validate {
    my ($this,$node) = @_;
}

=head1 DESCRIPTION

    .

=cut
