package IMPL::Web::View::TTView;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Context => 'IMPL::Web::View::TTContext'
	},
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_',
		'IMPL::Object::Serializable' => undef
	],
	props => [
		options => PROP_RW,
		view => PROP_RW,
		layout => PROP_RW,
		tt_ext => PROP_RW,
		includes => PROP_RW | PROP_LIST
	]
};

sub CTOR {
	my ($this) = @_;
	
	$this->tt_ext('tt') unless defined $this->tt_ext;
}

sub display {
	my ($this,$model,$template,$args) = @_;
	
	my $context = Context->new($this->options);
	my $layout = delete $args->{layout};
	
	return $context->invoke_environment(
		sub {
			my $ctx = shift;
			if ($layout) {
				return $ctx->invoke_environment(
					sub {
						return $ctx->render($layout,$args);
					},
					{
						base => $this->layout,
						content => sub {
							$ctx->invoke_environment(
								sub {
									return shift->display($model,$template,$args);
								},
								{
									base => $this->view
								}
							)
						}
					}
				);
			} else {
				return $ctx->invoke_environment(
					sub {
						return $ctx->display($model,$template,$args);
					},
					{
						base => $this->view
					}
				);
			}
		},{
			includes => scalar($this->includes),
			tt_ext => 'tt',
			document => {},
			debug => sub {
				warn @_;
			}
		}
	);
}

1;