#!/usr/bin/perl
use strict;

use IMPL::require {
	TTView => 'IMPL::Web::View::TTView'
};

use Time::HiRes qw(gettimeofday tv_interval);

my $t = [gettimeofday];

my $view = TTView->new(
	options => {
		INCLUDE_PATH => './Resources/view',
		INTERPOLATE => 1,
		RECURSION => 1000
	},
	view => 'site',
	layout => 'layout',
	includes => [
		'packages'
	]
);

print $view->display(
	{
		name => 'debugger',
		manufacture => {
			name => 'DEBUGGERS INC',
			address => [
				{
					coutry => 'Russuia',
					city => 'Moscow'
				},
				{
					country => 'GB',
					city => 'Essex'
				}
			]
		}
	},
	'product/view',
	{ layout => 'default' }
), "\n";

print "render page: ",tv_interval($t,[gettimeofday]),"ms\n";
   
