use strict;

package Test::Class::Meta;
use parent qw(IMPL::Test::Unit);

__PACKAGE__->PassThroughArgs;

use IMPL::Test qw(test failed);

test defineFooClassData => sub {
	Foo->class_data(info => {});	
};

test updateFooClassData => sub {
	Foo->class_data('info')->{data} = 'Foo' ;
};

test getFooClassData => sub {
	failed "Wrong class data", "Expected: Foo", "Got: ".Foo->class_data('info')->{data}  unless Foo->class_data('info')->{data} eq 'Foo';
};

test getBazClassData => sub {
	failed "Wrong class data", "Expected: Foo", "Got: ".Baz->class_data('info')->{data}  unless Baz->class_data('info')->{data} eq 'Foo';
};

test updateBarClassData => sub {
	Bar->class_data('info')->{data} = 'Bar';
};

test getBarClassData => sub {
	failed "Wrong class data", "Expected: Bar", "Got: ".Bar->class_data('info')->{data}  unless Bar->class_data('info')->{data} eq 'Bar';
};

test validatetFooClassData => sub {
	failed "Wrong class data", "Expected: Foo", "Got: ".Foo->class_data('info')->{data}  unless Foo->class_data('info')->{data} eq 'Foo';
};

test validateBazClassData => sub {
	failed "Wrong class data", "Expected: Foo", "Got: ".Baz->class_data('info')->{data}  unless Baz->class_data('info')->{data} eq 'Foo';
};

test getwrongBazClassData => sub {
	failed "Wrong class data", "Expected: undef", "Got: ".Foo->class_data( 'info2' ) if Foo->class_data( 'info2' );
};



package Foo;
use parent qw(IMPL::Class::Meta);

package Bar;
use parent qw(-norequire Foo);

package Baz;
use parent qw(-norequire Foo);

1;
